/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.network;

import com.mojang.serialization.DynamicOps;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.core.EnhancedCelestialsContext;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import corgitaco.enhancedcelestials.network.S2CPacket;
import corgitaco.enhancedcelestials.util.ClientUtil;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LunarForecastChangedPacket
implements S2CPacket {
    private final LunarForecast.Data lunarForecastData;

    public LunarForecastChangedPacket(LunarForecast lunarForecastData) {
        this(lunarForecastData.saveData());
    }

    public LunarForecastChangedPacket(LunarForecast.Data lunarForecastData) {
        this.lunarForecastData = lunarForecastData;
    }

    public static LunarForecastChangedPacket readFromPacket(FriendlyByteBuf buf) {
        try {
            return new LunarForecastChangedPacket((LunarForecast.Data)buf.m_266466_((DynamicOps)NbtOps.f_128958_, LunarForecast.Data.CODEC));
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        try {
            buf.m_266332_((DynamicOps)NbtOps.f_128958_, LunarForecast.Data.CODEC, (Object)this.lunarForecastData);
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    @Override
    public void handle(@Nullable Level level) {
        EnhancedCelestialsContext enhancedCelestialsContext;
        if (level != null && (enhancedCelestialsContext = ((EnhancedCelestialsWorldData)level).getLunarContext()) != null && level.f_46443_) {
            ClientUtil.scheduleClientAction(() -> {
                LunarForecast lunarForecast = enhancedCelestialsContext.getLunarForecast();
                lunarForecast.loadData(this.lunarForecastData);
            });
        }
    }
}

